/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.IndexRequestJob;
import com.aptana.index.core.Messages;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexFilesOfProjectJob
extends IndexRequestJob {
    private final IProject project;
    protected final Set<IFile> files;

    public IndexFilesOfProjectJob(IProject project, Set<IFile> files) {
        super(MessageFormat.format(Messages.IndexFilesOfProjectJob_Name, project.getName()), project.getLocationURI());
        this.project = project;
        this.files = files;
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 * this.files.size()));
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (!this.project.isAccessible()) {
            return Status.CANCEL_STATUS;
        }
        Index index = this.getIndex();
        if (index == null) {
            IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)MessageFormat.format("Index is null for container: {0}", this.getContainerURI()));
            return Status.CANCEL_STATUS;
        }
        try {
            Set<IFileStore> fileStores = this.toFileStores((IProgressMonitor)sub.newChild(this.files.size()));
            if (sub.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                this.indexFileStores(index, fileStores, (IProgressMonitor)sub.newChild(9 * this.files.size()));
            }
            catch (CoreException e) {
                IStatus iStatus = e.getStatus();
                return iStatus;
            }
        }
        finally {
            try {
                index.save();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)"An error occurred while saving an index", (Throwable)e);
            }
            sub.done();
        }
        return Status.OK_STATUS;
    }

    protected Set<IFileStore> toFileStores(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)this.files.size());
        HashSet<IFileStore> fileStores = new HashSet<IFileStore>(this.files.size());
        for (IFile file : this.files) {
            IFileStore store;
            block6: {
                store = EFS.getStore((URI)file.getLocationURI());
                if (store != null) break block6;
                sub.worked(1);
                continue;
            }
            try {
                try {
                    fileStores.add(store);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
                    sub.worked(1);
                    continue;
                }
            }
            catch (Throwable throwable) {
                sub.worked(1);
                throw throwable;
            }
            sub.worked(1);
        }
        return fileStores;
    }
}

